var BAUD_RATE = 9600;
var DELIMITER = ',';
var SENSOR_NUMBER = 14;
var NEWLINE = "\n";

var connectionId = -1;
var readBuffer = '';

function onOpen(openInfo) {
  connectionId = openInfo.connectionId;
  if (connectionId == -1) {
    setStatus('Could not connect to serial device.');
  } else {
    chrome.serial.read(connectionId, 1, onRead);
    setStatus('Connected to serial device.');
  }
}

function onRead(readInfo) {
  var value = readNextCharacter(readInfo);
  if (value != NEWLINE) {
    readBuffer += value;
  } else {
    processReadBuffer();
  }
  chrome.serial.read(connectionId, 1, onRead);
}

function processReadBuffer() {
  if (readBuffer.split(DELIMITER).length == SENSOR_NUMBER) {
    setRawData(readBuffer);
  }
  readBuffer = '';
}

function readNextCharacter(readInfo) {
  var uint8View = new Uint8Array(readInfo.data);
  return String.fromCharCode(uint8View[0]);
}

function setStatus(status) {
  document.getElementById('status').innerText = status;
}

function setRawData(rawData) {
  document.getElementById('raw-data').innerText = rawData;
}

function buildPortPicker(ports) {
  var eligiblePorts = getEligiblePorts(ports);
  var portPicker = populatePortPicker(eligiblePorts);
  portPicker.onchange = portChangedEvent;
}

function portChangedEvent() {
  if (connectionId != -1) {
    chrome.serial.close(connectionId, BAUD_RATE, openSelectedPort);
    setStatus('Loading...');
  }
  openSelectedPort(); 
}

function populatePortPicker(eligiblePorts) {
  var portPicker = document.getElementById('port-picker');
  eligiblePorts.forEach(function(port) {
    var portOption = document.createElement('option');
    portOption.value = portOption.innerText = port;
    portPicker.appendChild(portOption);
  });
  return portPicker;
}

function getEligiblePorts(ports) {
  var eligiblePorts = ports.filter(function(port) {
    return !port.match(/[Bb]luetooth/);
  });
  return eligiblePorts;
}

function openSelectedPort() {
  var portPicker = document.getElementById('port-picker');
  var selectedPort = portPicker.options[portPicker.selectedIndex].value;
  chrome.serial.open(selectedPort, onOpen);
}

onload = function() {
  chrome.serial.getPorts(function(ports) {
    buildPortPicker(ports)
    openSelectedPort();
  });
};
